/*:
 * @plugindesc Direct Menu to Inventory Screen - Opens the inventory screen directly when pressing the menu button.
 * @target MZ
 * @author Clay Davis
 *
 * @help
 * This plugin modifies the behavior of the menu button to open the inventory
 * screen directly instead of the main menu. All other menu options are
 * inaccessible with this plugin.
 *
 * Terms of Use:
 * Free for commercial and non-commercial use with credit to Clay Davis.
 */

(() => {
    // Override Scene_Map.prototype.callMenu to open inventory directly if Switch 101 is OFF
    Scene_Map.prototype.callMenu = function() {
        if (!$gameSwitches.value(101)) {  // Check if Switch 101 is OFF
            SoundManager.playOk();  // Play confirmation sound
            SceneManager.push(Scene_Item);  // Open inventory screen
        } else {
            SoundManager.playBuzzer();  // Play buzzer sound if Switch 101 is ON
        }
    };

    // Ensure Scene_Item works as expected
    const _Scene_Item_create = Scene_Item.prototype.create;
    Scene_Item.prototype.create = function() {
        _Scene_Item_create.call(this);
        this._categoryWindow.activate();  // Activate the category window for navigation
        this._categoryWindow.select(0);  // Default to the first category
    };

    // Optional: Skip automatic activation to allow manual selection
    Scene_Item.prototype.createCategoryWindow = function() {
        const rect = this.categoryWindowRect();
        this._categoryWindow = new Window_ItemCategory(rect);
        this._categoryWindow.setHandler('ok', this.onCategoryOk.bind(this));  // Handle selection
        this._categoryWindow.setHandler('cancel', this.popScene.bind(this));  // Handle cancel
        this.addWindow(this._categoryWindow);
    };
})();
